
export namespace Utils {

    export function findOrthographicCamera(sceneObject: SceneObject | null): SceneObject | null {
        if (!sceneObject) {
            return null;
        }
        const cameraComponent = sceneObject.getComponent('Component.Camera') as Camera | null;

        if (cameraComponent && cameraComponent.type == Camera.Type.Orthographic) {
            return sceneObject;
        }

        if (sceneObject.getParent()) {
            return findOrthographicCamera(sceneObject.getParent());
        }
        return null;
    }
}
